AnimatedBitmap = copy_table(Bitmap)

-- list handled parameters and their defaults
AnimatedBitmap.defaults = {
    shift_x = 0,
    shift_y = 0,
    angle = 0,
    alpha = 1,
    scale_x = 1,
    scale_y = 1,
    additive = false,
    color_r = 1,
    color_g = 1,
    color_b = 1,
    tshift_u = 0,
    tshift_v = 0,
}


function AnimatedBitmap:init(def, view)
    Bitmap.init(self, def, view)

    self.additive = def.additive or false
    self.blend_src = def.blend_src
    self.blend_dest = def.blend_dest

    local ani = Animator:new()

    for var, default in pairs(self.defaults) do
        if def[var] then
            if type(def[var]) == "table" then
                for i = 2, #def[var] do
                    ani:add_key(var, def[var][i][1], def[var][i][2])
                end
            else
                ani:add_key(var, 0, tonumber(def[var]))
            end
        else
            ani:add_key(var, 0, default)
        end
    end

    self.animator = ani
    self.time = 0
end


function AnimatedBitmap:destroy()
    Bitmap.destroy(self)
end


function AnimatedBitmap:restart()
    self.animator:restart()
end


function AnimatedBitmap:update(dt)
    self.animator:update(dt)
end

function AnimatedBitmap:render()
    local blend
    if self.blend_src or self.blend_dest then
        gfx_blending_src_dest(self.blend_src, self.blend_dest)
        blend = true
    elseif self.additive then
        gfx_blending("add")
        blend = true
    end
    local v = self.animator.val
    local color = gfx_color(v.color_r, v.color_g, v.color_b)
    gfx_render_sprite(self.bitmap, self.sprite, self.x + v.shift_x, self.y + v.shift_y, v.alpha, v.angle, v.scale_x, v.scale_y, color, v.tshift_u, v.tshift_v)
    if blend then
        gfx_blending("normal")
    end
end
